/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.config;

import com.aim.gpu.config.SpringSecurity;
import com.aim.gpu.dto.Response;
import com.aim.gpu.exception.CustomException;
import com.aim.gpu.security.CustomUserDetails;
import com.aim.gpu.util.JwtUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Autowired
    private CustomUserDetails userDetailsService;

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return SpringSecurity.PERMIT_ALL_MATCHERS.stream().anyMatch(matcher -> matcher.matches(request));
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        block4: {
            String token = null;
            String headerAuth = request.getHeader("Authorization");
            if (StringUtils.hasText((String)headerAuth) && headerAuth.startsWith("Bearer ")) {
                token = headerAuth.substring(7);
            }
            try {
                String username;
                UserDetails userDetails;
                if (token != null && JwtUtil.validateToken(token) && (userDetails = this.userDetailsService.loadUserByUsernameAndToken(username = JwtUtil.getUsernameFromToken((String)token), token)) != null) {
                    UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
                if (!(e instanceof CustomException)) break block4;
                CustomException cus = (CustomException)e;
                response.setContentType("application/json");
                response.setStatus(cus.getStatus().value());
                Response errorResponse = new Response(cus.getMessage(), null, cus.getStatus().value());
                ObjectMapper objectMapper = new ObjectMapper();
                response.getWriter().write(objectMapper.writeValueAsString((Object)errorResponse));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

