/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.controller;

import com.aim.gpu.dto.LoginDto;
import com.aim.gpu.dto.RegisterDto;
import com.aim.gpu.dto.ResetLinkDto;
import com.aim.gpu.dto.Response;
import com.aim.gpu.dto.SetNewPasswordDto;
import com.aim.gpu.dto.SocialSignupDto;
import com.aim.gpu.service.AuthService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity<Response> login(@RequestBody @Valid LoginDto loginDto) throws Exception {
        return this.authService.login(loginDto);
    }

    @PostMapping(value={"/social-signin"})
    public ResponseEntity<Response> socialSignin(@RequestParam String idToken, @RequestBody SocialSignupDto socialSignupDto) throws Exception {
        return this.authService.socialSignin(idToken, socialSignupDto);
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<Response> register(@RequestBody @Valid RegisterDto registerDto) throws Exception {
        return this.authService.registerUser(registerDto);
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<Response> forgotPassword(@RequestBody @Valid ResetLinkDto resetLinkDto) throws Exception {
        return this.authService.sendResetLink(resetLinkDto);
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<Response> resetPassword(@RequestBody @Valid SetNewPasswordDto setNewPasswordDto) throws Exception {
        return this.authService.setNewPassword(setNewPasswordDto);
    }

    @PostMapping(value={"/verify"})
    public ResponseEntity<Response> verify(@RequestParam String token) throws Exception {
        return this.authService.verify(token);
    }
}

