/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.controller;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.repository.FileLocationRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public"})
public class PublicController {
    @Autowired
    FileLocationRepository fileLocationRepository;

    @ResponseBody
    @GetMapping(value={"/file/{id}"})
    public ResponseEntity<FileSystemResource> downloadFile(@PathVariable(value="id") String id) {
        String mimeType;
        String filePath = this.fileLocationRepository.getPathById(id);
        if (filePath == null) {
            return ResponseEntity.notFound().build();
        }
        File file = new File(ApplicationPropertyConfig.IMAGE_SERVER_PATH + filePath);
        if (!file.exists() || !file.isFile()) {
            return ResponseEntity.notFound().build();
        }
        try {
            mimeType = Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            mimeType = "application/octet-stream";
        }
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)mimeType)).contentLength(file.length()).body((Object)new FileSystemResource(file));
    }
}

