/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.controller;

import com.aim.gpu.dto.BillingDetailsDto;
import com.aim.gpu.dto.ChangUserProfileDto;
import com.aim.gpu.dto.ChangePasswordDto;
import com.aim.gpu.dto.KycDto;
import com.aim.gpu.dto.Response;
import com.aim.gpu.service.UserService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private UserService userService;

    @GetMapping(value={"/profile"})
    public ResponseEntity<Response> profile() throws Exception {
        return this.userService.profile();
    }

    @PostMapping(value={"/profile"})
    public ResponseEntity<Response> updateProfile(@RequestBody @Valid ChangUserProfileDto changUserProfileDto) throws Exception {
        return this.userService.updateProfile(changUserProfileDto);
    }

    @PostMapping(value={"/change-password"})
    public ResponseEntity<Response> changePassword(@RequestBody @Valid ChangePasswordDto changePasswordDto) throws Exception {
        return this.userService.changePassword(changePasswordDto);
    }

    @PostMapping(value={"/billing-detail"})
    public ResponseEntity<Response> addUpdateBilling(@RequestBody @Valid BillingDetailsDto billingDetailsDto) throws Exception {
        return this.userService.addUpdateBilling(billingDetailsDto);
    }

    @PostMapping(value={"/kyc"}, consumes={"multipart/form-data"})
    public ResponseEntity<Response> addKyc(@Valid @ModelAttribute KycDto KycDto2, @RequestParam(value="file") MultipartFile file) throws Exception {
        return this.userService.addKyc(KycDto2, file);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<Response> logout() throws Exception {
        return this.userService.logout();
    }
}

