/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.exception;

import com.aim.gpu.dto.Response;
import com.aim.gpu.exception.CustomException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@ResponseBody
public class ExceptionHandlerAdvice
extends DefaultErrorAttributes {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);
    @Autowired
    private MessageSource messageSource;

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<Response> handleException(HttpServletResponse response, CustomException exp) {
        return Response.generateRestResponse((String)exp.getMessage(), (Object)exp.getData(), (HttpStatus)exp.getStatus());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handleAccessDeniedException(HttpServletResponse res) throws IOException {
        res.sendError(HttpStatus.FORBIDDEN.value(), this.messageSource.getMessage("Access.denied.error", null, Locale.US));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public ResponseEntity<Response> handleValidationException(Exception ex) {
        StringBuilder errorMessage;
        block3: {
            block2: {
                errorMessage = new StringBuilder();
                if (!(ex instanceof MethodArgumentNotValidException)) break block2;
                MethodArgumentNotValidException validationEx = (MethodArgumentNotValidException)ex;
                List fieldErrors = validationEx.getBindingResult().getFieldErrors();
                for (int i = 0; i < fieldErrors.size(); ++i) {
                    errorMessage.append(((FieldError)fieldErrors.get(i)).getDefaultMessage());
                    if (i >= fieldErrors.size() - 1) continue;
                    errorMessage.append("\n");
                }
                break block3;
            }
            if (!(ex instanceof BindException)) break block3;
            BindException bindException = (BindException)ex;
            List fieldErrors = bindException.getBindingResult().getFieldErrors();
            for (int i = 0; i < fieldErrors.size(); ++i) {
                errorMessage.append(((FieldError)fieldErrors.get(i)).getDefaultMessage());
                if (i >= fieldErrors.size() - 1) continue;
                errorMessage.append("\n");
            }
        }
        return Response.generateRestResponse((String)errorMessage.toString(), (HttpStatus)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DisabledException.class, CredentialsExpiredException.class})
    public ResponseEntity<Response> handleCredentialsExpiredException(Exception ex) {
        return Response.generateRestResponse((String)this.messageSource.getMessage("Verified.error.report.us.error", null, Locale.US), (HttpStatus)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<Response> handleBadCredentialsException(BadCredentialsException ex) {
        return Response.generateRestResponse((String)this.messageSource.getMessage("invalid.email.password", null, Locale.US), (HttpStatus)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={AccountExpiredException.class, LockedException.class})
    public ResponseEntity<Response> handleAccountExpiredException(Exception ex) {
        return Response.generateRestResponse((String)this.messageSource.getMessage("Deactivated.error.report.us.error", null, Locale.US), (HttpStatus)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Response> handleGeneralException(Exception ex) {
        LOGGER.error(ex.getLocalizedMessage());
        return Response.generateRestResponse((String)ex.getLocalizedMessage(), (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

