/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.dto.AssignRoleDto;
import com.aim.gpu.dto.DataAndCount;
import com.aim.gpu.dto.FunctionalityDto;
import com.aim.gpu.dto.ListRequestDto;
import com.aim.gpu.dto.Response;
import com.aim.gpu.entity.AdminFunctionality;
import com.aim.gpu.entity.KycRequest;
import com.aim.gpu.entity.User;
import com.aim.gpu.enums.Functionality;
import com.aim.gpu.enums.Role;
import com.aim.gpu.exception.CustomException;
import com.aim.gpu.repository.AdminFunctionalityRepository;
import com.aim.gpu.repository.FileLocationRepository;
import com.aim.gpu.repository.KycRequestRepository;
import com.aim.gpu.repository.UserRepository;
import com.aim.gpu.service.AdminService;
import com.aim.gpu.service.EmailSenderService;
import com.aim.gpu.service.UserService;
import com.aim.gpu.util.MessageUtils;
import com.aim.gpu.util.Utils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl
implements AdminService {
    @Autowired
    KycRequestRepository kycRequestRepository;
    @Autowired
    AdminFunctionalityRepository adminFunctionalityRepository;
    @Autowired
    FileLocationRepository fileLocationRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserRepository userRepository;
    @Autowired
    EmailSenderService emailSenderService;

    public ResponseEntity<Response> kycApprove(Long id) throws Exception {
        this.checkAdminPermissions(this.userService.findLoginUser(true), Functionality.KYC_REQUEST, "write");
        KycRequest kycRequest = (KycRequest)this.kycRequestRepository.findById((Object)id).orElseThrow(() -> new CustomException(MessageUtils.message((String)"kyc.find.error"), HttpStatus.BAD_REQUEST));
        User user = kycRequest.getUser();
        user.setKycVerified(true);
        this.userRepository.save((Object)user);
        this.emailSenderService.sendKycApproveEmail(user);
        String filePath = this.fileLocationRepository.getPathById(kycRequest.getFileLocation().getId());
        Utils.deleteFile((String)filePath);
        this.kycRequestRepository.delete((Object)kycRequest);
        return Response.generateRestResponse((String)MessageUtils.message((String)"kyc.approve.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> userFunctionality(Long id) throws Exception {
        List functionalityList = this.adminFunctionalityRepository.getFunctionalityList(id);
        return Response.generateRestResponse((String)MessageUtils.message((String)"success"), (Object)functionalityList, (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> assignRole(AssignRoleDto assignRoleDto) throws Exception {
        List addFunc;
        this.checkAdminPermissions(this.userService.findLoginUser(true), Functionality.ADMIN_MANAGER, "write");
        User user = (User)this.userRepository.findById((Object)assignRoleDto.getId()).orElseThrow(() -> new CustomException(MessageUtils.message((String)"user.found.error"), HttpStatus.BAD_REQUEST));
        if (user.getRole().equals((Object)Role.SUPER_ADMIN)) {
            throw new CustomException(MessageUtils.message((String)"user.super.admin.error"), HttpStatus.BAD_REQUEST);
        }
        List removeFunc = assignRoleDto.getRemoveFunctionality();
        if (removeFunc != null && !removeFunc.isEmpty()) {
            List removeList = this.adminFunctionalityRepository.findByAdminIdAndInFunctionality(assignRoleDto.getId(), removeFunc);
            this.adminFunctionalityRepository.deleteAll((Iterable)removeList);
        }
        if ((addFunc = assignRoleDto.getFunctionalityDto()) != null && !addFunc.isEmpty()) {
            for (FunctionalityDto dto : addFunc) {
                AdminFunctionality adminFunctionality = this.adminFunctionalityRepository.findByAdminIdAndFunctionality(assignRoleDto.getId(), dto.getFunctionality());
                if (adminFunctionality == null) {
                    adminFunctionality = new AdminFunctionality();
                }
                if (!dto.isRead() && (dto.isDelete() || dto.isWrite())) {
                    dto.setRead(true);
                }
                adminFunctionality.setAdmin(user);
                adminFunctionality.setFunctionality(dto.getFunctionality());
                adminFunctionality.setRead(dto.isRead());
                adminFunctionality.setWrite(dto.isWrite());
                adminFunctionality.setDelete(dto.isDelete());
                this.adminFunctionalityRepository.save((Object)adminFunctionality);
            }
            if (user.getRole().equals((Object)Role.USER)) {
                user.setRole(Role.ADMIN);
                this.userRepository.save((Object)user);
            }
        }
        return Response.generateRestResponse((String)MessageUtils.message((String)"assign.role.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> kycReject(Long id, String optionalReason) throws Exception {
        this.checkAdminPermissions(this.userService.findLoginUser(true), Functionality.KYC_REQUEST, "delete");
        KycRequest kycRequest = (KycRequest)this.kycRequestRepository.findById((Object)id).orElseThrow(() -> new CustomException(MessageUtils.message((String)"kyc.find.error"), HttpStatus.BAD_REQUEST));
        User user = kycRequest.getUser();
        this.emailSenderService.sendKycRejectEmail(user, optionalReason);
        String filePath = this.fileLocationRepository.getPathById(kycRequest.getFileLocation().getId());
        Utils.deleteFile((String)filePath);
        this.kycRequestRepository.delete((Object)kycRequest);
        return Response.generateRestResponse((String)MessageUtils.message((String)"kyc.reject.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> kycRequestList(ListRequestDto listRequestDto) throws Exception {
        this.checkAdminPermissions(this.userService.findLoginUser(true), Functionality.KYC_REQUEST, "read");
        String baseFileUrl = Utils.getBaseFileUrl();
        PageRequest pageable = listRequestDto.toPageable().withSort(Sort.Direction.ASC, new String[]{"createdDatetime"});
        Page kycRequestList = this.kycRequestRepository.getKycRequestList(baseFileUrl, (Pageable)pageable);
        return Response.generateRestResponse((String)MessageUtils.message((String)"kyc.list.success"), (Object)new DataAndCount(kycRequestList.toList(), kycRequestList.getTotalElements(), kycRequestList.getTotalPages()), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> userList(ListRequestDto listRequestDto) throws Exception {
        this.checkAdminPermissions(this.userService.findLoginUser(true), Functionality.ADMIN_MANAGER, "read");
        int page = listRequestDto.getPage() == null ? 1 : listRequestDto.getPage();
        int limit = listRequestDto.getLimit() == null ? 10 : listRequestDto.getLimit();
        String search = listRequestDto.getSearch() == null ? "" : listRequestDto.getSearch().trim();
        Role role = listRequestDto.getRole() == null ? null : listRequestDto.getRole();
        PageRequest pageable = PageRequest.of((int)page, (int)limit);
        Page usersPage = this.userRepository.getUsersList(search, (Pageable)pageable, role);
        return Response.generateRestResponse((String)MessageUtils.message((String)"success"), (Object)new DataAndCount(usersPage.stream().toList(), usersPage.getTotalElements(), usersPage.getTotalPages()), (HttpStatus)HttpStatus.OK);
    }

    private void checkAdminPermissions(User user, Functionality functionality, String type) throws CustomException {
        if (user.getRole().equals((Object)Role.SUPER_ADMIN)) {
            return;
        }
        boolean hasPermission = this.adminFunctionalityRepository.hasPermission(user.getId(), functionality, type);
        if (!hasPermission) {
            throw new CustomException(MessageUtils.message((String)"Access.denied.error"), HttpStatus.FORBIDDEN);
        }
    }
}

