/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.dto.LoginDto;
import com.aim.gpu.dto.LoginResponseDto;
import com.aim.gpu.dto.RegisterDto;
import com.aim.gpu.dto.ResetLinkDto;
import com.aim.gpu.dto.Response;
import com.aim.gpu.dto.SetNewPasswordDto;
import com.aim.gpu.dto.SocialDto;
import com.aim.gpu.dto.SocialSignupDto;
import com.aim.gpu.entity.User;
import com.aim.gpu.enums.AccountType;
import com.aim.gpu.enums.Role;
import com.aim.gpu.exception.CustomException;
import com.aim.gpu.repository.BillingDetailRepository;
import com.aim.gpu.repository.UserRepository;
import com.aim.gpu.service.AuthService;
import com.aim.gpu.service.EmailSenderService;
import com.aim.gpu.service.UserService;
import com.aim.gpu.util.JwtUtil;
import com.aim.gpu.util.MessageUtils;
import com.aim.gpu.util.Utils;
import com.google.gson.Gson;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AuthServiceImpl
implements AuthService {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BillingDetailRepository billingDetailRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EmailSenderService emailSenderService;

    public ResponseEntity<Response> login(LoginDto loginDto) throws Exception {
        Authentication authentication = this.authenticate(loginDto.getEmail(), loginDto.getPassword());
        if (!authentication.isAuthenticated()) {
            throw new CustomException(MessageUtils.message((String)"invalid.email.password"), HttpStatus.BAD_REQUEST);
        }
        User user = this.userRepository.findByEmail(loginDto.getEmail());
        if (user == null) {
            throw new CustomException(MessageUtils.message((String)"user.found.error"), HttpStatus.BAD_REQUEST);
        }
        String token = JwtUtil.generateToken((String)loginDto.getEmail());
        user.setToken(token);
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"login.success"), (Object)new LoginResponseDto(token, this.userService.getProfileDto(user)), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> socialSignin(String idToken, SocialSignupDto socialSignupDto) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity getDetails = restTemplate.exchange("https://oauth2.googleapis.com/tokeninfo?id_token=" + idToken, HttpMethod.GET, HttpEntity.EMPTY, String.class, new Object[0]);
        if (getDetails.getStatusCode() != HttpStatus.OK) {
            throw new CustomException(MessageUtils.message((String)"invalid.id.token.error"), HttpStatus.UNAUTHORIZED);
        }
        SocialDto socialDto = (SocialDto)new Gson().fromJson((String)getDetails.getBody(), SocialDto.class);
        User existingUser = this.userRepository.findByEmail(socialDto.getEmail());
        if (existingUser == null) {
            AccountType accountType;
            AccountType accountType2 = accountType = socialSignupDto != null && socialSignupDto.getAccType() != null ? socialSignupDto.getAccType() : AccountType.PERSONAL;
            if (accountType.equals((Object)AccountType.PROFESSIONAL) && (Utils.isNullOrBlank((String)socialSignupDto.getCompany()) || Utils.isNullOrBlank((String)socialSignupDto.getIndustry()))) {
                throw new CustomException(MessageUtils.message((String)"company.industry.error"), HttpStatus.BAD_REQUEST);
            }
            existingUser = new User();
            existingUser.setName(socialDto.getName());
            existingUser.setEmail(socialDto.getEmail());
            existingUser.setRole(Role.USER);
            existingUser.setVerified(true);
            existingUser.setPassword("");
            existingUser.setAccType(accountType);
            if (accountType.equals((Object)AccountType.PROFESSIONAL)) {
                existingUser.setCompany(socialSignupDto.getCompany());
                existingUser.setIndustry(socialSignupDto.getIndustry());
            }
        }
        String token = JwtUtil.generateToken((String)existingUser.getEmail());
        existingUser.setToken(token);
        existingUser = (User)this.userRepository.save((Object)existingUser);
        return Response.generateRestResponse((String)MessageUtils.message((String)"login.success"), (Object)new LoginResponseDto(token, this.userService.getProfileDto(existingUser)), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> registerUser(@Valid RegisterDto userDto) throws Exception {
        User existingUser = this.userRepository.findByEmail(userDto.getEmail());
        if (existingUser != null && existingUser.getEmail() != null && !existingUser.getEmail().isEmpty()) {
            throw new CustomException(MessageUtils.message((String)"email.exists.error"), HttpStatus.NOT_FOUND);
        }
        if (userDto.getAccType().equals((Object)AccountType.PROFESSIONAL) && (Utils.isNullOrBlank((String)userDto.getCompany()) || Utils.isNullOrBlank((String)userDto.getIndustry()))) {
            throw new CustomException(MessageUtils.message((String)"company.industry.error"), HttpStatus.BAD_REQUEST);
        }
        User user = new User();
        user.setName(userDto.getName());
        user.setEmail(userDto.getEmail());
        user.setPassword(this.passwordEncoder.encode((CharSequence)userDto.getPassword()));
        user.setRole(Role.USER);
        user.setAccType(userDto.getAccType());
        user.setCompany(userDto.getCompany());
        user.setIndustry(userDto.getIndustry());
        this.userRepository.save((Object)user);
        this.emailSenderService.sendVerificationLinkEmail(user, JwtUtil.generateToken((String)userDto.getEmail(), (Float)Float.valueOf(60.0f)));
        return Response.generateRestResponse((String)MessageUtils.message((String)"user.registered.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> sendResetLink(ResetLinkDto resetLinkDto) throws Exception {
        User existingUser = this.userRepository.findByEmail(resetLinkDto.getEmail());
        if (existingUser == null) {
            throw new CustomException(MessageUtils.message((String)"user.found.error"), HttpStatus.NOT_FOUND);
        }
        String key = JwtUtil.generateToken((String)existingUser.getEmail(), (Float)Float.valueOf(60.0f));
        this.emailSenderService.sendForgotPasswordLinkEmail(existingUser, key);
        return Response.generateRestResponse((String)MessageUtils.message((String)"forgot.password.email"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> setNewPassword(SetNewPasswordDto setNewPasswordDto) throws Exception {
        if (setNewPasswordDto.getKey() == null || !JwtUtil.validateToken((String)setNewPasswordDto.getKey())) {
            throw new CustomException(MessageUtils.message((String)"Invalid.credentials.error"), HttpStatus.BAD_REQUEST);
        }
        String email = JwtUtil.getUsernameFromToken((String)setNewPasswordDto.getKey());
        User user = this.userRepository.findByEmail(email);
        if (user == null || !user.getEmail().equals(email)) {
            throw new CustomException(MessageUtils.message((String)"Invalid.credentials.error"), HttpStatus.BAD_REQUEST);
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)setNewPasswordDto.getPassword()));
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"password.change.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> verify(String token) throws Exception {
        if (token == null || !JwtUtil.validateToken((String)token)) {
            throw new CustomException(MessageUtils.message((String)"user.verify.error"), HttpStatus.BAD_REQUEST);
        }
        String email = JwtUtil.getUsernameFromToken((String)token);
        User user = this.userRepository.findByEmail(email);
        if (user == null) {
            throw new CustomException(MessageUtils.message((String)"user.verify.error"), HttpStatus.BAD_REQUEST);
        }
        user.setVerified(true);
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"user.verify.success"), (HttpStatus)HttpStatus.OK);
    }

    private Authentication authenticate(String username, String password) {
        return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }
}

