/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.dto.Response;
import com.aim.gpu.dto.gpuProvider.RegionDto;
import com.aim.gpu.dto.gpuProvider.RegionResponseDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.GpuProviderService;
import com.aim.gpu.service.gpuProvider.CivoService;
import com.aim.gpu.service.gpuProvider.DenvrdataService;
import com.aim.gpu.service.gpuProvider.HyperStackService;
import com.aim.gpu.service.gpuProvider.LatitudeService;
import com.aim.gpu.service.gpuProvider.LeaderGpuService;
import com.aim.gpu.util.MessageUtils;
import com.aim.gpu.util.Utils;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GpuProviderServiceImpl
implements GpuProviderService {
    @Autowired
    HyperStackService hyperStackService;
    @Autowired
    LatitudeService latitudeService;
    @Autowired
    LeaderGpuService leaderGpuService;
    @Autowired
    DenvrdataService denvrdataService;
    @Autowired
    CivoService civoService;
    @Autowired
    CommonService commonService;

    public ResponseEntity<Response> getRegionList(String _provider) {
        boolean allProvider;
        Providers provider = Providers.getEnum((String)_provider);
        ArrayList regionList = new ArrayList();
        boolean bl = allProvider = provider == null;
        if (allProvider || provider.equals((Object)Providers.HYPERSTACK)) {
            regionList.addAll(this.hyperStackService.getRegionList());
        }
        if (allProvider || provider.equals((Object)Providers.CIVO)) {
            regionList.addAll(this.civoService.getRegionList());
        }
        if (allProvider || provider.equals((Object)Providers.LATITUDE)) {
            regionList.addAll(this.latitudeService.getRegionList());
        }
        if (allProvider || provider.equals((Object)Providers.DENVRDATA)) {
            regionList.addAll(this.denvrdataService.getRegionList());
        }
        Set regions = regionList.stream().map(RegionDto::getCountry).collect(Collectors.toSet());
        return Response.generateRestResponse((String)MessageUtils.message((String)"region.list.success"), (Object)new RegionResponseDto(regions, regionList), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> getGPUList(String _provider, String region) {
        Providers provider;
        boolean allProvider;
        ArrayList gpuList = new ArrayList();
        if (Utils.isNullOrBlank((String)region) || region.equalsIgnoreCase("ALL")) {
            region = null;
        }
        boolean bl = allProvider = (provider = Providers.getEnum((String)_provider)) == null;
        if (allProvider || provider.equals((Object)Providers.HYPERSTACK)) {
            gpuList.addAll(this.hyperStackService.getGPUs(region));
        }
        if (allProvider || provider.equals((Object)Providers.CIVO)) {
            gpuList.addAll(this.civoService.getGPUs(region));
        }
        if (allProvider || provider.equals((Object)Providers.LATITUDE)) {
            gpuList.addAll(this.latitudeService.getGPUs(region));
        }
        if (allProvider || provider.equals((Object)Providers.LEADERGPU)) {
            gpuList.addAll(this.leaderGpuService.getGPUs(region));
        }
        if (allProvider || provider.equals((Object)Providers.DENVRDATA)) {
            gpuList.addAll(this.denvrdataService.getGPUs(region));
        }
        return Response.generateRestResponse((String)MessageUtils.message((String)"gpu.list.success"), gpuList, (HttpStatus)HttpStatus.OK);
    }
}

