/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl.gpuProvider;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.gpuProvider.GpuDto;
import com.aim.gpu.dto.gpuProvider.RegionDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.ApiService;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.gpuProvider.CivoService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class CivoServiceImpl
implements CivoService {
    @Autowired
    ApiService apiService;
    @Autowired
    CommonService commonService;
    private final String API_KEY = ApplicationPropertyConfig.CIVO_API_KEY;

    public List<RegionDto> getRegionList() {
        List<Object> regionList = new ArrayList<RegionDto>();
        String url = "https://api.civo.com/v2/regions";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return regionList;
        }
        JsonArray responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonArray();
        regionList = responseBody.asList().stream().map(JsonElement::getAsJsonObject).map(region -> {
            RegionDto regionMap = new RegionDto();
            regionMap.setProvider(Providers.CIVO.name);
            regionMap.setOriginal((Object)region.toString());
            regionMap.setName(region.get("country_name").getAsString());
            regionMap.setCountry(this.commonService.getCountry(regionMap.getName()));
            regionMap.setId(region.get("code").getAsString());
            return regionMap;
        }).collect(Collectors.toList());
        return regionList;
    }

    public List<GpuDto> getGPUs(String region) {
        List<Object> gpuList = new ArrayList<GpuDto>();
        String url = "https://api.civo.com/v2/sizes";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonArray responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonArray();
        gpuList = responseBody.asList().stream().map(JsonElement::getAsJsonObject).filter(gpu -> gpu.get("type").getAsString().equals("Instance") && gpu.get("gpu_count").getAsInt() > 0).map(gpu -> {
            GpuDto gpuDto = new GpuDto();
            gpuDto.setProvider(Providers.CIVO.name);
            gpuDto.setOriginal((Object)gpu.toString());
            gpuDto.setId(gpu.get("name").getAsString());
            gpuDto.setName(gpu.get("nice_name").getAsString());
            return gpuDto;
        }).collect(Collectors.toList());
        return gpuList;
    }

    private ResponseEntity<String> callApi(String url, HttpMethod method, Map<String, Object> bodyData) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.set("Authorization", "Bearer " + this.API_KEY);
        MultiValueMap requestBody = this.apiService.getRequestBodyFromMap(bodyData);
        return this.apiService.callApi(url, method, headers, (Object)requestBody);
    }
}

