/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl.gpuProvider;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.gpuProvider.GpuDto;
import com.aim.gpu.dto.gpuProvider.RegionDto;
import com.aim.gpu.dto.gpuProvider.SpecificationDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.ApiService;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.gpuProvider.HyperStackService;
import com.aim.gpu.util.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class HyperStackServiceImpl
implements HyperStackService {
    @Autowired
    ApiService apiService;
    @Autowired
    CommonService commonService;
    private final String API_KEY = ApplicationPropertyConfig.HYPERSTACK_API_KEY;

    public List<RegionDto> getRegionList() {
        List<Object> regionList = new ArrayList<RegionDto>();
        String url = "https://infrahub-api.nexgencloud.com/v1/core/regions";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return regionList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("regions")) {
            return regionList;
        }
        JsonArray regions = responseBody.getAsJsonArray("regions");
        regionList = regions.asList().stream().map(JsonElement::getAsJsonObject).map(region -> {
            JsonObject regionMap = region.getAsJsonObject();
            RegionDto regionDto = new RegionDto();
            regionDto.setProvider(Providers.HYPERSTACK.name);
            regionDto.setOriginal((Object)regionMap.toString());
            String name = regionMap.get("name").getAsString();
            regionDto.setName(name);
            regionDto.setCountry(this.commonService.getCountry(name));
            regionDto.setId(name);
            return regionDto;
        }).collect(Collectors.toList());
        return regionList;
    }

    public List<GpuDto> getGPUs(String region) {
        List<Object> gpuList = new ArrayList<GpuDto>();
        String url = "https://infrahub-api.nexgencloud.com/v1/core/flavors";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("data")) {
            return gpuList;
        }
        JsonArray data = responseBody.getAsJsonArray("data");
        gpuList = data.asList().stream().map(JsonElement::getAsJsonObject).filter(gpu -> !Utils.isNullOrBlank((String)gpu.get("gpu").getAsString())).filter(gpu -> region == null || this.commonService.getCountry(gpu.get("region_name").getAsString()).equals(region)).flatMap(gpu -> {
            List flavors = gpu.getAsJsonArray("flavors").asList();
            if (flavors.isEmpty()) {
                return Stream.empty();
            }
            return flavors.stream().map(JsonElement::getAsJsonObject).map(flavor -> {
                GpuDto gpuDto = new GpuDto();
                gpuDto.setOriginal((Object)flavor.toString());
                gpuDto.setId(flavor.get("id").getAsString());
                gpuDto.setName(flavor.get("name").getAsString());
                SpecificationDto specificationDto = this.getSpecification(flavor);
                gpuDto.setSpecification(specificationDto);
                gpuDto.setProvider(Providers.HYPERSTACK.name);
                return gpuDto;
            });
        }).collect(Collectors.toList());
        return gpuList;
    }

    private SpecificationDto getSpecification(JsonObject json) {
        SpecificationDto specificationDto = new SpecificationDto();
        try {
            if (json.has("cpu")) {
                int cpuCount = json.get("cpu").getAsInt();
                specificationDto.setCpu(cpuCount + " vCPUs");
            }
            if (json.has("ram")) {
                double ram = json.get("ram").getAsDouble();
                specificationDto.setRam(String.format("%.1f GB", ram));
            }
            if (json.has("disk")) {
                int disk = json.get("disk").getAsInt();
                specificationDto.setDisk(disk + " GB");
            }
            if (json.has("gpu") && !json.get("gpu").getAsString().isEmpty() && json.has("gpu_count")) {
                String gpuType = json.get("gpu").getAsString();
                int gpuCount = json.get("gpu_count").getAsInt();
                if (gpuCount > 0) {
                    specificationDto.setGpu(gpuType + " x " + gpuCount);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return specificationDto;
    }

    private ResponseEntity<String> callApi(String url, HttpMethod method, Map<String, Object> bodyData) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.set("api_key", this.API_KEY);
        MultiValueMap requestBody = this.apiService.getRequestBodyFromMap(bodyData);
        return this.apiService.callApi(url, method, headers, (Object)requestBody);
    }
}

