/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl.gpuProvider;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.gpuProvider.GpuDto;
import com.aim.gpu.dto.gpuProvider.PriceDto;
import com.aim.gpu.dto.gpuProvider.RegionDto;
import com.aim.gpu.dto.gpuProvider.SpecificationDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.ApiService;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.gpuProvider.LatitudeService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class LatitudeServiceImpl
implements LatitudeService {
    @Autowired
    ApiService apiService;
    @Autowired
    CommonService commonService;
    private final String API_KEY = ApplicationPropertyConfig.LATITUDE_API_KEY;

    public List<RegionDto> getRegionList() {
        List<Object> regionList = new ArrayList<RegionDto>();
        String _url = "https://api.latitude.sh/regions";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)_url);
        uriBuilder.queryParam("page[size]", new Object[]{Integer.MAX_VALUE});
        uriBuilder.queryParam("page[number]", new Object[]{1});
        String url = uriBuilder.toUriString();
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return regionList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("data")) {
            return regionList;
        }
        JsonArray data = responseBody.getAsJsonArray("data");
        regionList = data.asList().stream().map(JsonElement::getAsJsonObject).map(region -> {
            RegionDto regionDto = new RegionDto();
            regionDto.setProvider(Providers.LATITUDE.name);
            regionDto.setOriginal((Object)region.toString());
            JsonObject attributes = region.getAsJsonObject("attributes");
            JsonObject country = attributes.getAsJsonObject("country");
            regionDto.setName((country == null ? attributes : country).get("name").getAsString());
            regionDto.setCountry(this.commonService.getCountry(regionDto.getName()));
            regionDto.setId((country == null ? attributes : country).get("slug").getAsString());
            return regionDto;
        }).collect(Collectors.toList());
        return regionList;
    }

    public List<GpuDto> getGPUs(String region) {
        List<Object> gpuList = new ArrayList<GpuDto>();
        String _url = "https://api.latitude.sh/plans";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)_url);
        uriBuilder.queryParam("filter[gpu]", new Object[]{true});
        uriBuilder.queryParam("filter[in_stock]", new Object[]{true});
        String url = uriBuilder.toUriString();
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("data")) {
            return gpuList;
        }
        JsonArray data = responseBody.getAsJsonArray("data");
        gpuList = data.asList().stream().map(JsonElement::getAsJsonObject).map(gpu -> {
            JsonElement regionEle;
            JsonObject attributes = gpu.getAsJsonObject("attributes");
            JsonArray regions = attributes.getAsJsonArray("regions");
            if (regions == null || regions.isEmpty()) {
                return null;
            }
            JsonElement jsonElement = regionEle = region == null ? regions.get(0) : (JsonElement)regions.asList().stream().map(JsonElement::getAsJsonObject).filter(r -> this.commonService.getCountry(r.get("name").getAsString()).equals(region)).findFirst().orElse(null);
            if (regionEle == null) {
                return null;
            }
            JsonObject gpuAndRegion = new JsonObject();
            gpuAndRegion.add("gpu", (JsonElement)gpu);
            gpuAndRegion.add("region", (JsonElement)regionEle.getAsJsonObject());
            return gpuAndRegion;
        }).filter(Objects::nonNull).map(gpuAndRegion -> {
            JsonObject gpu = gpuAndRegion.getAsJsonObject("gpu");
            JsonObject regionObj = gpuAndRegion.getAsJsonObject("region");
            GpuDto gpuDto = new GpuDto();
            gpuDto.setProvider(Providers.LATITUDE.name);
            gpuDto.setOriginal((Object)gpu.toString());
            gpuDto.setId(gpu.get("id").getAsString());
            gpuDto.setName(gpu.get("attributes").getAsJsonObject().get("name").getAsString());
            SpecificationDto specificationDto = this.getSpecification(gpu.getAsJsonObject("specs"));
            gpuDto.setSpecification(specificationDto);
            gpuDto.setPrice(this.getPrice(regionObj.getAsJsonObject("pricing")));
            return gpuDto;
        }).collect(Collectors.toList());
        return gpuList;
    }

    public List<GpuDto> getVMs(String region) {
        List<Object> gpuList = new ArrayList<GpuDto>();
        String url = "https://api.latitude.sh/plans/virtual_machines";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("data")) {
            return gpuList;
        }
        JsonArray data = responseBody.getAsJsonArray("data");
        gpuList = data.asList().stream().map(JsonElement::getAsJsonObject).filter(gpu -> {
            if (region == null) {
                return true;
            }
            JsonObject attributes = gpu.getAsJsonObject("attributes");
            JsonArray regions = attributes.getAsJsonArray("regions");
            return regions.asList().stream().map(JsonElement::getAsJsonObject).anyMatch(r -> this.commonService.getCountry(r.get("name").getAsString()).equals(region));
        }).map(gpu -> {
            GpuDto gpuDto = new GpuDto();
            gpuDto.setProvider(Providers.LATITUDE.name);
            gpuDto.setOriginal((Object)gpu.toString());
            gpuDto.setId(gpu.get("id").getAsString());
            gpuDto.setName(gpu.get("attributes").getAsJsonObject().get("name").getAsString());
            return gpuDto;
        }).collect(Collectors.toList());
        return gpuList;
    }

    private SpecificationDto getSpecification(JsonObject specs) {
        SpecificationDto specificationDto = new SpecificationDto();
        try {
            JsonArray drives;
            JsonObject memory;
            JsonObject gpu;
            int count;
            String type;
            JsonObject cpu;
            if (specs.has("cpu") && !(cpu = specs.getAsJsonObject("cpu")).isEmpty()) {
                type = cpu.has("type") ? cpu.get("type").getAsString() : "";
                double clock = cpu.has("clock") ? cpu.get("clock").getAsDouble() : 0.0;
                int cores = cpu.has("cores") ? cpu.get("cores").getAsInt() : 0;
                count = cpu.has("count") ? cpu.get("count").getAsInt() : 0;
                String cpuStr = String.format("%s, %d cores @%.2f GHz x %d", type, cores, clock, count);
                specificationDto.setCpu(cpuStr);
            }
            if (specs.has("gpu") && !(gpu = specs.getAsJsonObject("gpu")).isEmpty()) {
                type = gpu.has("type") ? gpu.get("type").getAsString() : "";
                int count2 = gpu.has("count") ? gpu.get("count").getAsInt() : 0;
                String gpuStr = String.format("%s x %d", type, count2);
                specificationDto.setGpu(gpuStr);
            }
            if (specs.has("memory") && !(memory = specs.getAsJsonObject("memory")).isEmpty()) {
                int total = memory.has("total") ? memory.get("total").getAsInt() : 0;
                String ramStr = String.format("%d GB", total);
                specificationDto.setRam(ramStr);
            }
            if (specs.has("drives") && !(drives = specs.getAsJsonArray("drives")).isEmpty()) {
                ArrayList<String> driveDescriptions = new ArrayList<String>();
                for (JsonElement driveElement : drives) {
                    JsonObject drive = driveElement.getAsJsonObject();
                    count = drive.has("count") ? drive.get("count").getAsInt() : 0;
                    String size = drive.has("size") ? drive.get("size").getAsString() : "";
                    String type2 = drive.has("type") ? drive.get("type").getAsString() : "";
                    driveDescriptions.add(String.format("%s %s x %d", size, type2, count));
                }
                String diskStr = String.join((CharSequence)", ", driveDescriptions);
                specificationDto.setDisk(diskStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return specificationDto;
    }

    private PriceDto getPrice(JsonObject pricingJson) {
        PriceDto priceDto = new PriceDto();
        try {
            JsonObject pricing = pricingJson.getAsJsonObject("pricing");
            JsonObject selectedCurrencyJson = null;
            String currencyCode = null;
            if (pricing.has("USD")) {
                selectedCurrencyJson = pricing.getAsJsonObject("USD");
                currencyCode = "USD";
            } else {
                Map.Entry firstEntry = (Map.Entry)pricing.entrySet().iterator().next();
                selectedCurrencyJson = ((JsonElement)firstEntry.getValue()).getAsJsonObject();
                currencyCode = (String)firstEntry.getKey();
            }
            priceDto.setCurrency(currencyCode);
            if (selectedCurrencyJson.has("hour")) {
                String hourStr = selectedCurrencyJson.get("hour").getAsString();
                priceDto.setHour(hourStr);
                priceDto.setPrice(hourStr);
            }
            if (selectedCurrencyJson.has("minute")) {
                priceDto.setMinute(selectedCurrencyJson.get("minute").getAsString());
            }
            if (selectedCurrencyJson.has("day")) {
                priceDto.setDay(selectedCurrencyJson.get("day").getAsString());
            }
            if (selectedCurrencyJson.has("week")) {
                priceDto.setWeek(selectedCurrencyJson.get("week").getAsString());
            }
            if (selectedCurrencyJson.has("month")) {
                priceDto.setMonth(selectedCurrencyJson.get("month").getAsString());
            }
            if (selectedCurrencyJson.has("year")) {
                priceDto.setYear(selectedCurrencyJson.get("year").getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return priceDto;
    }

    private ResponseEntity<String> callApi(String url, HttpMethod method, Map<String, Object> bodyData) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/vnd.api+json");
        headers.set("Authorization", this.API_KEY);
        MultiValueMap requestBody = this.apiService.getRequestBodyFromMap(bodyData);
        return this.apiService.callApi(url, method, headers, (Object)requestBody);
    }
}

