/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl.gpuProvider;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.gpuProvider.GpuDto;
import com.aim.gpu.dto.gpuProvider.PriceDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.ApiService;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.gpuProvider.LeaderGpuService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class LeaderGpuServiceImpl
implements LeaderGpuService {
    @Autowired
    ApiService apiService;
    @Autowired
    CommonService commonService;
    private String authToken;
    private String userId;

    public List<GpuDto> getGPUs(String region) {
        List<Object> gpuList = new ArrayList<GpuDto>();
        if (region != null) {
            return gpuList;
        }
        this.ensureAuthenticated();
        String url = "https://api.leaderssl.com/api/v1/users/" + this.userId + "/servers/products";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonArray responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonArray();
        gpuList = responseBody.asList().stream().map(JsonElement::getAsJsonObject).map(gpu -> {
            GpuDto gpuDto = new GpuDto();
            gpuDto.setName(gpu.get("name").getAsString());
            gpuDto.setId(gpu.get("id").getAsString());
            gpuDto.setPrice(this.getPrice(gpu));
            gpuDto.setProvider(Providers.LEADERGPU.name);
            gpuDto.setOriginal((Object)gpu.toString());
            return gpuDto;
        }).collect(Collectors.toList());
        return gpuList;
    }

    private PriceDto getPrice(JsonObject json) {
        PriceDto priceDto = new PriceDto();
        try {
            if (json.has("currency")) {
                priceDto.setCurrency(json.get("currency").getAsString());
            }
            if (json.has("period_type") && json.has("price")) {
                String period = json.get("period_type").getAsString().toLowerCase();
                String price = json.get("price").getAsString();
                switch (period) {
                    case "minute": {
                        priceDto.setMinute(price);
                        break;
                    }
                    case "hour": {
                        priceDto.setHour(price);
                        break;
                    }
                    case "day": {
                        priceDto.setDay(price);
                        break;
                    }
                    case "week": {
                        priceDto.setWeek(price);
                        break;
                    }
                    case "month": {
                        priceDto.setMonth(price);
                        break;
                    }
                    case "year": {
                        priceDto.setYear(price);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return priceDto;
    }

    private void ensureAuthenticated() {
        if (this.authToken == null || this.userId == null) {
            this.authenticate();
        }
    }

    private void authenticate() {
        String url = "https://api.leaderssl.com/api/v1/users/signin";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"login", (Object)ApplicationPropertyConfig.LEADERGPU_USERNAME);
        requestBody.add((Object)"password", (Object)ApplicationPropertyConfig.LEADERGPU_PASSWORD);
        ResponseEntity response = this.apiService.callApi(url, HttpMethod.POST, headers, (Object)requestBody);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
            this.authToken = responseBody.get("auth_token").getAsString();
            this.userId = responseBody.get("id").getAsString();
        }
    }

    private ResponseEntity<String> callApi(String url, HttpMethod method, Map<String, Object> bodyData) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        if (this.authToken != null) {
            headers.set("X-AUTH-TOKEN", this.authToken);
        }
        MultiValueMap requestBody = this.apiService.getRequestBodyFromMap(bodyData);
        return this.apiService.callApi(url, method, headers, (Object)requestBody);
    }
}

