/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.util;

import com.aim.gpu.config.ApplicationPropertyConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JwtUtil {
    static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    private static final String SECRET_KEY = ApplicationPropertyConfig.JWT_SECRET_KEY;
    private static final String ALGORITHM = "AES";
    private static final String SECRET_KEY_16 = "rapidquoteAI_key";

    public static String generateToken(String username) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(11, ApplicationPropertyConfig.JWT_EXPIRATION_HOUR);
        return Jwts.builder().subject(username).issuedAt(new Date()).expiration(calendar.getTime()).signWith((Key)JwtUtil.getKey()).compact();
    }

    public static String generateToken(String username, Float minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, minute.intValue());
        Date validity = calendar.getTime();
        return Jwts.builder().subject(username).issuedAt(new Date()).expiration(validity).signWith((Key)JwtUtil.getKey()).compact();
    }

    public static SecretKey getKey() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] keyBytes = messageDigest.digest(SECRET_KEY.getBytes());
            return Keys.hmacShaKeyFor((byte[])keyBytes);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static boolean validateToken(String token) {
        try {
            Jwts.parser().verifyWith(JwtUtil.getKey()).build().parseSignedClaims((CharSequence)token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getTokenData(String token) {
        String[] parts = token.split("\\.");
        return new String(Base64.getUrlDecoder().decode(parts[1]));
    }

    public static String getUsernameFromToken(String token) {
        return ((Claims)Jwts.parser().verifyWith(JwtUtil.getKey()).build().parseSignedClaims((CharSequence)token).getPayload()).getSubject();
    }

    public static String encryptString(String data) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("rapidquoteAI_key".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            return Base64.getUrlEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptString(String data) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("rapidquoteAI_key".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            byte[] decryptedData = cipher.doFinal(Base64.getUrlDecoder().decode(data));
            return new String(decryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

