/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class MessageUtils {
    private static MessageSource messageSource;
    private static HttpServletRequest request;

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        MessageUtils.messageSource = messageSource;
    }

    @Autowired
    public void setRequest(HttpServletRequest request) {
        MessageUtils.request = request;
    }

    public static String message(String code) {
        Locale locale = Locale.ENGLISH;
        String lang = request.getHeader("lang-type");
        if (lang != null && lang.equals("fr")) {
            locale = Locale.FRENCH;
        }
        if (lang != null && lang.equals("es")) {
            locale = new Locale("es", "ES");
        }
        return messageSource.getMessage(code, null, locale);
    }
}

