/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.config;

import com.aim.gpu.config.JwtAuthenticationFilter;
import com.aim.gpu.dto.Response;
import com.aim.gpu.enums.Role;
import com.aim.gpu.security.CustomUserDetails;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
public class SpringSecurity {
    @Autowired
    private CustomUserDetails userDetailsService;
    public static List<String> PERMIT_ALL_URLS = List.of("/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html", "/api/auth/**", "/public/**");
    public static final List<AntPathRequestMatcher> PERMIT_ALL_MATCHERS = PERMIT_ALL_URLS.stream().map(AntPathRequestMatcher::new).toList();

    @Bean
    static PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    JwtAuthenticationFilter jwtAuthenticationFilter() {
        return new JwtAuthenticationFilter();
    }

    @Bean
    public DaoAuthenticationProvider authenticationProvider(UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(userDetailsService);
        provider.setPasswordEncoder(passwordEncoder);
        return provider;
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationProvider authenticationProvider) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).cors(cors -> cors.configurationSource(request -> {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(List.of("*"));
            configuration.setAllowedMethods(List.of("*"));
            configuration.setAllowedHeaders(List.of("*"));
            return configuration;
        })).authorizeHttpRequests(authorizeRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeRequests.requestMatchers(PERMIT_ALL_URLS.toArray(new String[0]))).permitAll().requestMatchers(new String[]{"/api/user/**"})).hasAnyAuthority(new String[]{Role.ADMIN.name(), Role.SUPER_ADMIN.name(), Role.USER.name()}).requestMatchers(new String[]{"/api/admin/**"})).hasAnyAuthority(new String[]{Role.ADMIN.name(), Role.SUPER_ADMIN.name()}).anyRequest()).authenticated()).exceptionHandling(e -> e.authenticationEntryPoint((request, response, authException) -> {
            response.setContentType("application/json");
            response.setStatus(401);
            Response errorResponse = new Response("It looks like you're not signed in or your session has expired. Please log in again to continue.", null, 401);
            ObjectMapper objectMapper = new ObjectMapper();
            response.getWriter().write(objectMapper.writeValueAsString((Object)errorResponse));
        }).accessDeniedHandler((request, response, authException) -> {
            response.setContentType("application/json");
            response.setStatus(403);
            Response errorResponse = new Response("You do not have permission to access this API.", null, 403);
            ObjectMapper objectMapper = new ObjectMapper();
            response.getWriter().write(objectMapper.writeValueAsString((Object)errorResponse));
        })).addFilterBefore((Filter)this.jwtAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder builder) throws Exception {
        builder.userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(SpringSecurity.passwordEncoder());
    }
}

