/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.repository;

import com.aim.gpu.dto.FunctionalityDto;
import com.aim.gpu.entity.AdminFunctionality;
import com.aim.gpu.enums.Functionality;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface AdminFunctionalityRepository
extends JpaRepository<AdminFunctionality, Long> {
    @Query(value="select f from AdminFunctionality f where f.admin.id = :id AND f.functionality in :functionalities")
    public List<AdminFunctionality> findByAdminIdAndInFunctionality(Long var1, List<Functionality> var2);

    @Query(value="select f from AdminFunctionality f where f.admin.id = :id AND f.functionality = :functionality")
    public AdminFunctionality findByAdminIdAndFunctionality(Long var1, Functionality var2);

    @Query(value="SELECT new com.aim.gpu.dto.FunctionalityDto(a.functionality, a.read, a.write, a.delete) FROM AdminFunctionality a WHERE a.admin.id = :id")
    public List<FunctionalityDto> getFunctionalityList(Long var1);

    @Query(value="SELECT CASE WHEN COUNT(af) > 0 THEN true ELSE false END FROM AdminFunctionality af WHERE af.admin.id = :adminId AND (af.functionality = :functionality OR af.functionality = 'FULL_ACCESS') AND ((:type = 'read' AND af.read = true) OR (:type = 'write' AND af.write = true) OR (:type = 'delete' AND af.delete = true))")
    public boolean hasPermission(Long var1, Functionality var2, String var3);
}

