/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.security;

import com.aim.gpu.exception.CustomException;
import com.aim.gpu.repository.UserRepository;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetails
implements UserDetailsService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MessageSource messageSource;

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        com.aim.gpu.entity.User user = this.userRepository.findByEmail(email);
        if (user == null) {
            throw new UsernameNotFoundException(this.messageSource.getMessage("invalid.email.password", null, Locale.US));
        }
        return this.loadUser(user);
    }

    public UserDetails loadUserByUsernameAndToken(String email, String token) throws UsernameNotFoundException, CustomException {
        com.aim.gpu.entity.User user = this.userRepository.findByEmail(email);
        if (user == null) {
            throw new UsernameNotFoundException(this.messageSource.getMessage("invalid.email.password", null, Locale.US));
        }
        if (user.getToken() == null || !user.getToken().equals(token)) {
            throw new CustomException(this.messageSource.getMessage("logout.success", null, Locale.US), HttpStatus.CONFLICT);
        }
        return this.loadUser(user);
    }

    private UserDetails loadUser(com.aim.gpu.entity.User user) {
        ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();
        roles.add(new SimpleGrantedAuthority(user.getRole().name()));
        String pass = user.getPassword() == null ? "" : user.getPassword();
        return new User(user.getEmail(), pass, user.isVerified(), true, true, true, roles);
    }
}

