/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.service.ApiService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ApiServiceImpl
implements ApiService {
    static final Logger logger = LoggerFactory.getLogger(ApiServiceImpl.class);

    public MultiValueMap<String, Object> getRequestBodyFromMap(Map<String, Object> bodyData) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        if (bodyData != null) {
            for (Map.Entry<String, Object> entry : bodyData.entrySet()) {
                requestBody.add((Object)entry.getKey(), entry.getValue());
            }
        }
        return requestBody;
    }

    public ResponseEntity<String> callApi(String url, HttpMethod method, HttpHeaders headers, Object requestBody) {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            return restTemplate.exchange(url, method, requestEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            logger.error("error calling API", ex);
            return new ResponseEntity((Object)ex.getResponseBodyAsString(), ex.getStatusCode());
        }
        catch (RestClientException ex) {
            return new ResponseEntity((Object)("Error calling API: " + ex.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

