/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.config.MailPropertyConfig;
import com.aim.gpu.dto.MailSenderDto;
import com.aim.gpu.entity.User;
import com.aim.gpu.service.EmailSenderService;
import com.aim.gpu.service.EmailService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailSenderServiceImpl
implements EmailSenderService {
    static final Logger logger = LoggerFactory.getLogger(EmailSenderServiceImpl.class);
    @Autowired
    private EmailService emailService;

    private void startExecutorService(MailSenderDto mailSenderDto) {
        if (mailSenderDto.getFrom() == null) {
            mailSenderDto.setFrom(MailPropertyConfig.EMAIL);
        }
        this.emailService.sendJavaMail(mailSenderDto);
    }

    public void sendVerificationLinkEmail(User user, String token) {
        MailSenderDto mailSenderDto = new MailSenderDto();
        mailSenderDto.setTo(user.getEmail());
        mailSenderDto.setSubject("GPUManager - Your Email Verification Link");
        mailSenderDto.setTemplatePath("email/verificationEmail");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("userName", user.getName());
        templateData.put("verificationLink", ApplicationPropertyConfig.FRONTEND_URL + "/successful-verified?token=" + token);
        mailSenderDto.setTemplateData(templateData);
        this.startExecutorService(mailSenderDto);
    }

    public void sendForgotPasswordLinkEmail(User user, String key) {
        MailSenderDto mailSenderDto = new MailSenderDto();
        mailSenderDto.setTo(user.getEmail());
        mailSenderDto.setSubject("GPU Manager - Your Forgot password Link");
        mailSenderDto.setTemplatePath("email/forgotPasswordEmail");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("userName", user.getName());
        templateData.put("redirectUrl", ApplicationPropertyConfig.BACKEND_URL + "/reset-password?key=" + key);
        mailSenderDto.setTemplateData(templateData);
        this.startExecutorService(mailSenderDto);
    }

    public void sendKycRequestEmail(User user, Date date, List<String> emails) {
        MailSenderDto mailSenderDto = new MailSenderDto();
        mailSenderDto.setTos(emails.toArray(new String[0]));
        mailSenderDto.setSubject("GPU Manager - New Kyc Request");
        mailSenderDto.setTemplatePath("email/kycRequestEmail");
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.put("userName", user.getName());
        templateData.put("userEmail", user.getEmail());
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM dd, yyyy 'at' HH:mm z");
        templateData.put("submissionDate", sdf.format(date));
        mailSenderDto.setTemplateData(templateData);
        this.startExecutorService(mailSenderDto);
    }

    public void sendKycApproveEmail(User user) {
        MailSenderDto mailSenderDto = new MailSenderDto();
        mailSenderDto.setTo(user.getEmail());
        mailSenderDto.setSubject("GPU Manager - Kyc Request Approved");
        mailSenderDto.setTemplatePath("email/kycApproveEmail");
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.put("userName", user.getName());
        mailSenderDto.setTemplateData(templateData);
        this.startExecutorService(mailSenderDto);
    }

    public void sendKycRejectEmail(User user, String optionalReason) {
        MailSenderDto mailSenderDto = new MailSenderDto();
        mailSenderDto.setTo(user.getEmail());
        mailSenderDto.setSubject("GPU Manager - Kyc Request Rejected");
        mailSenderDto.setTemplatePath("email/kycARejectEmail");
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.put("userName", user.getName());
        templateData.put("optionalReason", optionalReason);
        mailSenderDto.setTemplateData(templateData);
        this.startExecutorService(mailSenderDto);
    }

    @Generated
    public EmailSenderServiceImpl() {
    }
}

