/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.dto.MailSenderDto;
import com.aim.gpu.service.EmailService;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EmailServiceImpl
implements EmailService {
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private TemplateEngine templateEngine;
    static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    @Async(value="emailTaskExecutor")
    public void sendJavaMail(MailSenderDto mailSenderDto) {
        try {
            logger.info("Starting Email sent to : {}", (Object)mailSenderDto.getTo());
            MimeMessage mimemessage = this.mailSender.createMimeMessage();
            MimeMessageHelper message = EmailServiceImpl.getMimeMessageHelper((MailSenderDto)mailSenderDto, (MimeMessage)mimemessage);
            if (mailSenderDto.getTemplatePath() != null && mailSenderDto.getTemplateData() != null) {
                Context ctx = new Context(Locale.US);
                for (Map.Entry entry : mailSenderDto.getTemplateData().entrySet()) {
                    ctx.setVariable((String)entry.getKey(), entry.getValue());
                }
                String htmlContent = this.templateEngine.process(mailSenderDto.getTemplatePath(), (IContext)ctx);
                message.setText(htmlContent, true);
            }
            this.mailSender.send(mimemessage);
            logger.info("Email sent to : {}", (Object)mailSenderDto.getTo());
        }
        catch (Exception e) {
            logger.error("Error occurred while sending email : {}", (Object)String.valueOf(e));
        }
    }

    @NotNull
    private static MimeMessageHelper getMimeMessageHelper(MailSenderDto mailSenderDto, MimeMessage mimemessage) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimemessage, true);
        message.setFrom(mailSenderDto.getFrom());
        if (mailSenderDto.getTo() != null) {
            message.setTo(mailSenderDto.getTo());
        }
        if (mailSenderDto.getTos() != null && mailSenderDto.getTos().length > 0) {
            message.setTo(mailSenderDto.getTos());
        }
        if (mailSenderDto.getFile() != null) {
            message.addAttachment(mailSenderDto.getFile().getName(), mailSenderDto.getFile());
        }
        message.setBcc(mailSenderDto.getFrom());
        message.setSubject(mailSenderDto.getSubject());
        return message;
    }

    @Async(value="emailTaskExecutor")
    public void sendSendgridMail(MailSenderDto mailSenderDto) {
    }

    @Async(value="emailTaskExecutor")
    public void sendMailgunMail(MailSenderDto mailSenderDto) {
    }
}

