/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.BillingDetailsDto;
import com.aim.gpu.dto.ChangUserProfileDto;
import com.aim.gpu.dto.ChangePasswordDto;
import com.aim.gpu.dto.KycDto;
import com.aim.gpu.dto.ProfileDto;
import com.aim.gpu.dto.Response;
import com.aim.gpu.entity.BillingDetail;
import com.aim.gpu.entity.FileLocation;
import com.aim.gpu.entity.KycRequest;
import com.aim.gpu.entity.User;
import com.aim.gpu.enums.AccountType;
import com.aim.gpu.enums.Role;
import com.aim.gpu.exception.CustomException;
import com.aim.gpu.repository.AdminFunctionalityRepository;
import com.aim.gpu.repository.BillingDetailRepository;
import com.aim.gpu.repository.KycRequestRepository;
import com.aim.gpu.repository.UserRepository;
import com.aim.gpu.service.EmailSenderService;
import com.aim.gpu.service.UserService;
import com.aim.gpu.util.MessageUtils;
import com.aim.gpu.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private KycRequestRepository kycRequestRepository;
    @Autowired
    private BillingDetailRepository billingDetailRepository;
    @Autowired
    private AdminFunctionalityRepository adminFunctionalityRepository;
    @Autowired
    private EmailSenderService emailSenderService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private HttpServletRequest request;

    public User findLoginUser(boolean check) throws CustomException {
        User user;
        Principal principal = this.request.getUserPrincipal();
        User user2 = user = principal == null ? null : this.userRepository.findByEmail(principal.getName());
        if (check && user == null) {
            throw new CustomException(MessageUtils.message((String)"user.found.error"), HttpStatus.NOT_FOUND);
        }
        return user;
    }

    public ResponseEntity<Response> profile() throws Exception {
        User user = this.findLoginUser(false);
        return Response.generateRestResponse((String)MessageUtils.message((String)"user.get.profile.success"), (Object)this.getProfileDto(user), (HttpStatus)HttpStatus.OK);
    }

    public ProfileDto getProfileDto(User user) {
        BillingDetailsDto billingDetailsDto = this.billingDetailRepository.getByUserId(user.getId());
        List functionalityList = user.getRole().equals((Object)Role.SUPER_ADMIN) || user.getRole().equals((Object)Role.ADMIN) ? this.adminFunctionalityRepository.getFunctionalityList(user.getId()) : null;
        return new ProfileDto(user.getName(), user.getEmail(), user.getRole(), user.getCompany(), user.getIndustry(), user.getCreatedDatetime(), user.getAccType(), user.isKycVerified(), billingDetailsDto, functionalityList);
    }

    public ResponseEntity<Response> updateProfile(ChangUserProfileDto changUserProfileDto) throws Exception {
        User user = this.findLoginUser(true);
        user.setName(changUserProfileDto.getName());
        if (user.getAccType().equals((Object)AccountType.PROFESSIONAL)) {
            user.setCompany(changUserProfileDto.getCompany());
            user.setIndustry(changUserProfileDto.getIndustry());
        }
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"user.updated.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> changePassword(ChangePasswordDto changePasswordDto) throws Exception {
        User user = this.findLoginUser(true);
        if (!this.passwordEncoder.matches((CharSequence)changePasswordDto.getOldPassword(), user.getPassword())) {
            throw new CustomException(MessageUtils.message((String)"user.change.password.error"), HttpStatus.BAD_REQUEST);
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)changePasswordDto.getNewPassword()));
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"user.change.password.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> logout() throws Exception {
        User user = this.findLoginUser(true);
        user.setToken(null);
        this.userRepository.save((Object)user);
        return Response.generateRestResponse((String)MessageUtils.message((String)"logout.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> addUpdateBilling(BillingDetailsDto billingDetailsDto) throws Exception {
        User user = this.findLoginUser(true);
        BillingDetail billingDetail = this.billingDetailRepository.findByUserId(user.getId());
        if (billingDetail == null) {
            billingDetail = new BillingDetail();
            billingDetail.setUser(user);
        }
        billingDetail.setName(billingDetailsDto.getName());
        billingDetail.setEmail(billingDetailsDto.getEmail());
        billingDetail.setPhone(billingDetailsDto.getPhone());
        if (user.getAccType().equals((Object)AccountType.PROFESSIONAL)) {
            if (Utils.isNullOrBlank((String)billingDetailsDto.getCompany()) || Utils.isNullOrBlank((String)billingDetailsDto.getVat())) {
                throw new CustomException(MessageUtils.message((String)"company.vat.error"), HttpStatus.BAD_REQUEST);
            }
            billingDetail.setCompany(billingDetailsDto.getCompany());
            billingDetail.setVat(billingDetailsDto.getVat());
        }
        billingDetail.setAddress(billingDetailsDto.getAddress());
        billingDetail.setCity(billingDetailsDto.getCity());
        billingDetail.setState(billingDetailsDto.getState());
        billingDetail.setCountry(billingDetailsDto.getCountry());
        billingDetail.setZip(billingDetailsDto.getZip());
        this.billingDetailRepository.save((Object)billingDetail);
        return Response.generateRestResponse((String)MessageUtils.message((String)"billing.update.success"), (HttpStatus)HttpStatus.OK);
    }

    public ResponseEntity<Response> addKyc(KycDto kycDto, MultipartFile file) throws Exception {
        User user = this.findLoginUser(true);
        if (user.isKycVerified()) {
            throw new CustomException(MessageUtils.message((String)"kyc.already.verified.error"), HttpStatus.BAD_REQUEST);
        }
        KycRequest kycRequest = this.kycRequestRepository.findByUserId(user.getId());
        if (kycRequest != null) {
            throw new CustomException(MessageUtils.message((String)"kyc.exists.error"), HttpStatus.BAD_REQUEST);
        }
        kycRequest = new KycRequest();
        kycRequest.setUser(user);
        kycRequest.setDocument(kycDto.getDocument());
        FileLocation fileLocation = new FileLocation();
        fileLocation.setFilePath(Utils.addFile((String)ApplicationPropertyConfig.KYC_FILE_BASE_PATH, (MultipartFile)file));
        kycRequest.setFileLocation(fileLocation);
        kycRequest = (KycRequest)this.kycRequestRepository.save((Object)kycRequest);
        List adminEmails = this.userRepository.findAllAdminEmails();
        if (!adminEmails.isEmpty()) {
            this.emailSenderService.sendKycRequestEmail(user, kycRequest.getCreatedDatetime(), adminEmails);
        }
        return Response.generateRestResponse((String)MessageUtils.message((String)"kyc.add.success"), (HttpStatus)HttpStatus.OK);
    }
}

