/*
 * Decompiled with CFR 0.152.
 */
package com.aim.gpu.service.impl.gpuProvider;

import com.aim.gpu.config.ApplicationPropertyConfig;
import com.aim.gpu.dto.gpuProvider.GpuDto;
import com.aim.gpu.dto.gpuProvider.PriceDto;
import com.aim.gpu.dto.gpuProvider.RegionDto;
import com.aim.gpu.dto.gpuProvider.SpecificationDto;
import com.aim.gpu.enums.Providers;
import com.aim.gpu.service.ApiService;
import com.aim.gpu.service.CommonService;
import com.aim.gpu.service.gpuProvider.DenvrdataService;
import com.aim.gpu.util.JwtUtil;
import com.aim.gpu.util.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class DenvrdataServiceImpl
implements DenvrdataService {
    @Autowired
    ApiService apiService;
    @Autowired
    CommonService commonService;
    private String refreshToken;
    private String accessToken;

    public List<RegionDto> getRegionList() {
        this.ensureAuthenticated();
        List<Object> regionList = new ArrayList<RegionDto>();
        String url = "https://api.cloud.denvrdata.com/api/v1/clusters/GetAll";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return regionList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("result")) {
            return regionList;
        }
        JsonArray result = responseBody.getAsJsonArray("result");
        regionList = result.asList().stream().map(JsonElement::getAsString).map(region -> new RegionDto(this.commonService.getCountry(region), region, region, Providers.DENVRDATA.name, region)).collect(Collectors.toList());
        return regionList;
    }

    public List<GpuDto> getGPUs(String region) {
        this.ensureAuthenticated();
        List<Object> gpuList = new ArrayList<GpuDto>();
        String url = "https://api.cloud.denvrdata.com/api/v1/servers/virtual/GetConfigurations";
        ResponseEntity response = this.callApi(url, HttpMethod.GET, null);
        if (response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
            return gpuList;
        }
        JsonObject responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject();
        if (responseBody == null || !responseBody.has("result")) {
            return gpuList;
        }
        JsonObject result = responseBody.getAsJsonObject("result");
        if (result == null || !result.has("items")) {
            return gpuList;
        }
        JsonArray items = result.getAsJsonArray("items");
        gpuList = items.asList().stream().map(JsonElement::getAsJsonObject).filter(gpu -> {
            if (region == null) {
                return true;
            }
            JsonArray clusters = gpu.getAsJsonArray("clusters");
            if (clusters == null || clusters.isEmpty()) {
                return false;
            }
            return clusters.asList().stream().map(r -> this.commonService.getCountry(r.getAsString())).anyMatch(region::equals);
        }).map(gpu -> {
            GpuDto gpuDto = new GpuDto();
            gpuDto.setOriginal((Object)gpu.toString());
            gpuDto.setId(gpu.get("id").getAsString());
            gpuDto.setName(gpu.get("name").getAsString());
            SpecificationDto specificationDto = this.getSpecification(gpu);
            gpuDto.setSpecification(specificationDto);
            gpuDto.setPrice(this.getPrice(gpu));
            gpuDto.setProvider(Providers.DENVRDATA.name);
            return gpuDto;
        }).collect(Collectors.toList());
        return gpuList;
    }

    private SpecificationDto getSpecification(JsonObject gpuJson) {
        SpecificationDto specificationDto = new SpecificationDto();
        try {
            if (gpuJson.has("text_name") && gpuJson.has("gpus")) {
                String gpuName = gpuJson.get("text_name").getAsString();
                int gpus = gpuJson.get("gpus").getAsInt();
                String gpuStr = String.format("%s x %d", gpuName, gpus);
                specificationDto.setGpu(gpuStr);
            }
            if (gpuJson.has("vcpus")) {
                int vcpus = gpuJson.get("vcpus").getAsInt();
                String cpuStr = String.format("%d vCPUs", vcpus);
                specificationDto.setCpu(cpuStr);
            }
            if (gpuJson.has("memory")) {
                int memory = gpuJson.get("memory").getAsInt();
                String ramStr = String.format("%d GB", memory);
                specificationDto.setRam(ramStr);
            }
            if (gpuJson.has("storage")) {
                int storage = gpuJson.get("storage").getAsInt();
                String diskStr = String.format("%d GB", storage);
                specificationDto.setDisk(diskStr);
            }
            if (gpuJson.has("compute_network")) {
                String string = gpuJson.get("compute_network").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return specificationDto;
    }

    private PriceDto getPrice(JsonObject gpuJson) {
        PriceDto priceDto = new PriceDto();
        priceDto.setCurrency("USD");
        try {
            if (gpuJson.has("price")) {
                priceDto.setHour(gpuJson.get("price").getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return priceDto;
    }

    private void ensureAuthenticated() {
        boolean isAccessTokenValid = this.isTokenValid(this.accessToken);
        if (isAccessTokenValid) {
            return;
        }
        boolean isRefreshTokenValid = this.isTokenValid(this.refreshToken);
        if (isRefreshTokenValid) {
            this.refreshAuthenticate();
        } else {
            this.authenticate();
        }
    }

    private boolean isTokenValid(String token) {
        if (token == null) {
            return false;
        }
        String tokenData = JwtUtil.getTokenData((String)token);
        JsonObject tokenObject = JsonParser.parseString((String)tokenData).getAsJsonObject();
        Date expiration = Utils.convertTimestamp((String)tokenObject.get("exp").getAsString());
        return expiration.before(new Date());
    }

    private void authenticate() {
        JsonObject responseBody;
        JsonObject result;
        String url = "https://api.cloud.denvrdata.com/api/TokenAuth/Authenticate";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("userNameOrEmailAddress", ApplicationPropertyConfig.DENVRDATA_USERNAME);
        requestBody.put("password", ApplicationPropertyConfig.DENVRDATA_PASSWORD);
        requestBody.put("rememberClient", true);
        ResponseEntity response = this.apiService.callApi(url, HttpMethod.POST, headers, requestBody);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && (result = (responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject()).getAsJsonObject("result")) != null && !result.isEmpty()) {
            this.accessToken = result.get("accessToken").getAsString();
            this.refreshToken = result.get("refreshToken").getAsString();
        }
    }

    private void refreshAuthenticate() {
        JsonObject responseBody;
        JsonObject result;
        String url = "https://api.cloud.denvrdata.com/api/TokenAuth/RefreshToken?refreshToken=" + this.refreshToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        HashMap requestBody = new HashMap();
        ResponseEntity response = this.apiService.callApi(url, HttpMethod.POST, headers, requestBody);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && (result = (responseBody = JsonParser.parseString((String)((String)response.getBody())).getAsJsonObject()).getAsJsonObject("result")) != null && !result.isEmpty()) {
            this.accessToken = result.get("accessToken").getAsString();
        }
    }

    private ResponseEntity<String> callApi(String url, HttpMethod method, Map<String, Object> bodyData) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.set("Authorization", "Bearer " + this.accessToken);
        MultiValueMap requestBody = this.apiService.getRequestBodyFromMap(bodyData);
        return this.apiService.callApi(url, method, headers, (Object)requestBody);
    }
}

